<?php

namespace App\Http\Controllers\Admin;

use App\Categories;
use App\GalleryImage;
use App\Http\Controllers\Controller;
use App\Libraries\Utils;
use App\Posts;
use App\PostTags;
use App\Sources;
use App\SubCategories;
use App\Tags;
use App\Users;
use Illuminate\Support\Str;
use Input;
use Session;

class PostsController extends Controller
{

    public function create()
    {
        $admins = Utils::getUsersInGroup(Users::TYPE_ADMIN);

        return view('admin.posts.create', ['categories' => Categories::all(), 'admins' => $admins]);
    }

    public function store()
    {

        $v = \Validator::make(['title' => Input::get('title'),
            'description' => Input::get('description'),
            'category_id' => Input::get('sub_category'),
            'author' => Input::get('author')
        ], ['title' => 'required', 'description' => 'required', 'category_id' => 'required', 'author' => 'required']);

        if ($v->fails()) {
            Session::flash('error_msg', Utils::messages($v));
            return redirect()->back()->withInput(Input::all());
        }

        $post_item = new Posts();
        $post_item->author_id = Input::get('author');
        $post_item->title = Input::get('title');
        $post_item->slug = Str::slug(Input::get('title'));
        $post_item->featured = Input::has('featured');
        $post_item->category_id = Input::get('sub_category');
        $post_item->description = Input::get('description');
        $post_item->type = Posts::TYPE_MANUAL;
        $post_item->render_type = Input::get('render_type');
        $post_item->video_embed_code = Input::get('video_embed_code');
        $post_item->image_parallax = Input::has('image_parallax');
        $post_item->video_parallax = Input::has('video_parallax');
        $post_item->rating_box = Input::has('rating_box');
        $post_item->show_in_mega_menu = Input::has('show_in_mega_menu');
        $post_item->show_featured_image_in_post = Input::has('show_featured_image_in_post');
        $post_item->show_author_box = Input::has('show_author_box');
        $post_item->show_author_socials = Input::has('show_author_socials');
        $post_item->views = 0;

        if (Input::hasFile('featured_image')) {
            $post_item->featured_image = Utils::imageUpload(Input::file('featured_image'), 'images');
        }

        $post_item->status = Input::get('status');
        $post_item->save();

        if (strlen(Input::get('tags')) > 0) {

            $tags = explode(',', Input::get('tags'));

            foreach ($tags as $tag) {

                $tag_exists = Tags::where('title', $tag)->first();

                if (!empty($tag_exists)) {
                    //Tag already present
                    $pt = new PostTags();
                    $pt->post_id = $post_item->id;
                    $pt->tag_id = $tag_exists->id;
                    $pt->save();
                } else {
                    $new_tag = new Tags();
                    $new_tag->title = $tag;
                    $new_tag->slug = Str::slug($tag);
                    $new_tag->save();

                    $pt = new PostTags();
                    $pt->post_id = $post_item->id;
                    $pt->tag_id = $new_tag->id;
                    $pt->save();
                }

            }
        }

        if (Input::hasFile('image_gallery') && Input::get('render_type') == Posts::RENDER_TYPE_GALLERY) {

            $gallery = Input::file('image_gallery');

            foreach ($gallery as $g) {
                $file = Utils::imageUpload($g, 'images');
                $i = new GalleryImage();
                $i->post_id = $post_item->id;
                $i->image = $file;
                $i->save();
            }
        }


        Session::flash('success_msg', 'Post created successfully');
        return redirect()->to('/admin/posts/all');

    }

    public function edit($id)
    {

        if (!is_null($id) && sizeof(Posts::where('id', $id)->get()) > 0) {

            $post = Posts::where('id', $id)->first();

            $post->category = SubCategories::where('id', $post->category_id)->first();
            $post->parent_category = Categories::where('id', $post->category->parent_id)->first();

            $post->gallery = GalleryImage::where('post_id', $post->id)->get();

            $post_tags = PostTags::where('post_id', $post->id)->lists('tag_id');

            if (sizeof($post_tags) > 0) {
                $post->tags = Tags::whereIn('id', $post_tags)->lists('title')->toArray();
            } else {
                $post->tags = [];
            }

            if ($post->type == Posts::TYPE_SOURCE)
                $post->source = Sources::where('id', $post->source_id)->first();

            $admins = Utils::getUsersInGroup(Users::TYPE_ADMIN);

            return view('admin.posts.edit', ['post' => $post, 'categories' => Categories::all(), 'sub_categories' => SubCategories::where('parent_id', $post->parent_category->id)->get(), 'admins' => $admins]);

        } else {
            Session::flash('error_msg', 'Post not found');
            return redirect()->to('/admin/posts/all');
        }

    }

    public function delete($id)
    {
        if (!is_null($id) && sizeof(Posts::where('id', $id)->get()) > 0) {

            Posts::where('id', $id)->delete();

            Session::flash('success_msg', 'Post deleted successfully');
            return redirect()->to('/admin/posts/all');

        } else {
            Session::flash('error_msg', 'Post not found');
            return redirect()->to('/admin/posts/all');
        }
    }

    public function update()
    {

        if (Input::has('id') && sizeof(Posts::where('id', Input::get('id'))->get()) > 0) {

            if (sizeof(Posts::where('title', Input::get('title'))->where('id', '!=', Input::get('id'))->get()) > 0) {
                Session::flash('error_msg', 'Post with given title already exists');
                return redirect()->back()->withInput(Input::except("featured_image"));
            }

            $post_item = Posts::where('id', Input::get('id'))->first();
            $post_item->author_id = Input::get('author');
            $post_item->title = Input::get('title');
            $post_item->slug = Str::slug(Input::get('title'));
            $post_item->featured = Input::has('featured');
            $post_item->category_id = Input::get('sub_category');
            $post_item->description = Input::get('description');
            $post_item->render_type = Input::get('render_type');
            $post_item->video_embed_code = Input::get('video_embed_code');
            $post_item->image_parallax = Input::has('image_parallax');
            $post_item->video_parallax = Input::has('video_parallax');
            $post_item->rating_box = Input::get('rating_box');
            $post_item->show_in_mega_menu = Input::has('show_in_mega_menu');
            $post_item->show_featured_image_in_post = Input::has('show_featured_image_in_post');
            $post_item->show_author_box = Input::has('show_author_box');
            $post_item->show_author_socials = Input::has('show_author_socials');

            if (Input::get('render_type') == Posts::RENDER_TYPE_TEXT || Input::get('render_type') == Posts::RENDER_TYPE_VIDEO) {
                $post_item->featured_image = "";
            }

            if (Input::get('render_type') == Posts::RENDER_TYPE_IMAGE) {
                if (Input::hasFile('featured_image')) {
                    $post_item->featured_image = Utils::imageUpload(Input::file('featured_image'), 'images');;
                }
            }

            $post_item->status = Input::get('status');
            $post_item->save();

            PostTags::where('post_id', $post_item->id)->delete();

            if (strlen(Input::get('tags')) > 0) {

                $tags = explode(',', Input::get('tags'));

                foreach ($tags as $tag) {

                    $tag_exists = Tags::where('title', $tag)->first();

                    if (!empty($tag_exists)) {
                        //Tag already present
                        $pt = new PostTags();
                        $pt->post_id = $post_item->id;
                        $pt->tag_id = $tag_exists->id;
                        $pt->save();
                    } else {
                        $new_tag = new Tags();
                        $new_tag->title = $tag;
                        $new_tag->slug = Str::slug($tag);
                        $new_tag->save();

                        $pt = new PostTags();
                        $pt->post_id = $post_item->id;
                        $pt->tag_id = $new_tag->id;
                        $pt->save();
                    }

                }
            }

            if (Input::hasFile('image_gallery') && Input::get('render_type') == Posts::RENDER_TYPE_GALLERY) {

                GalleryImage::where('post_id', $post_item->id)->delete();

                $gallery = Input::file('image_gallery');

                foreach ($gallery as $g) {
                    $file = Utils::imageUpload($g, 'images');
                    $i = new GalleryImage();
                    $i->post_id = $post_item->id;
                    $i->image = $file;
                    $i->save();
                }
            }

            $post_gallery_img = GalleryImage::where('post_id', $post_item->id)->first();

            if (!empty($post_gallery_img) && Input::get('render_type') == Posts::RENDER_TYPE_GALLERY) {
                $post_item->featured_image = $post_gallery_img->image;
            }

            $post_item->save();

            Session::flash('success_msg', 'Post updated successfully');
            return redirect()->to('/admin/posts/all');

        } else {
            Session::flash('error_msg', 'Post not found');
            return redirect()->to('/admin/posts/all');
        }

    }

    public function all()
    {

        $posts = Posts::all();

        foreach ($posts as $post) {

            $post->category = SubCategories::where('id', $post->category_id)->first();

            if ($post->type == Posts::TYPE_SOURCE) {
                $post->source = Sources::where('id', $post->source_id)->first();
            }
        }

        return view('admin.posts.all', ['posts' => $posts]);
    }

}